//
//  BPRegexFormatter.h
//  BIViews
//
//  Created by Brent Gulanowski on 11-01-27.
//  Copyright 2011 Marketcircle Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>


@interface BPRegexFormatter : NSFormatter {
	NSPredicate *matchPredicate;
	NSCharacterSet *allowedCharacters;
	NSCharacterSet *invertedCharacters;
	NSString *expression;
	NSUInteger maxLength;
	BOOL caseSensitive;
	BOOL allowEmpty;
}

@property (nonatomic, retain) NSPredicate *matchPredicate;
@property (nonatomic, retain) NSCharacterSet *allowedCharacters;
@property (nonatomic, retain) NSString *expression;
@property (nonatomic) NSUInteger maxLength;
@property (nonatomic) BOOL caseSensitive;
@property (nonatomic) BOOL allowEmpty;

+ (BPRegexFormatter *)regexFormatterWithExpression:(NSString *)expression;
+ (BPRegexFormatter *)emailFormatter;

@end
